<?php
include 'navbar.php'; // Include the Navbar
include 'db.php';

// Variable to store the success or error message
$showModal = false;
$success_message = "";
$error_message = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $shop_name = $_POST['shop_name'];
    $full_address = $_POST['full_address'];

    // Insert order into database
    $sql = "INSERT INTO orders (shop_name, full_address) VALUES ('$shop_name', '$full_address')";
    if ($conn->query($sql) === TRUE) {
        $success_message = "New order submitted successfully!";
        $showModal = true; // Show success modal
    } else {
        $error_message = "Error: " . $sql . "<br>" . $conn->error;
        $showModal = true; // Show error modal
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Submit Order</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="container mx-auto py-10 px-4 sm:px-6 lg:px-8">
    <div class="bg-white p-8 rounded-lg shadow-lg max-w-lg mx-auto">
        <h1 class="text-3xl font-semibold text-center text-gray-800 mb-6">Submit Your Order</h1>

        <!-- Form to Submit Order -->
        <form action="order.php" method="POST">
            <!-- Shop Name Selection -->
            <div class="mb-4">
                <label for="shop_name" class="block text-gray-700 font-semibold mb-2">Select Shop:</label>
                <select id="shop_name" name="shop_name" class="w-full p-3 border border-gray-300 rounded-md" required>
                    <option value="Beautyflare">Beautyflare</option>
                    <option value="Thanaka Bangladesh">Thanaka Bangladesh</option>
                </select>
            </div>

            <!-- Full Address -->
            <div class="mb-4">
                <label for="full_address" class="block text-gray-700 font-semibold mb-2">Full Address:</label>
                <textarea id="full_address" name="full_address" class="w-full p-3 border border-gray-300 rounded-md" rows="4" required></textarea>
            </div>

            <!-- Submit Button -->
            <div class="mb-4">
                <button type="submit" class="w-full py-3 px-6 bg-blue-500 text-white font-semibold rounded-lg hover:bg-blue-600 transition duration-200">Submit Order</button>
            </div>
        </form>
    </div>
</div>

<!-- Modal for Success/Error -->
<div class="fixed inset-0 bg-gray-800 bg-opacity-50 flex items-center justify-center z-50" style="display: <?php echo $showModal ? 'flex' : 'none'; ?>;" id="modal">
    <div class="bg-white p-8 rounded-lg shadow-lg max-w-sm w-full">
        <!-- Success Message -->
        <?php if ($success_message): ?>
            <div class="text-green-500">
                <h2 class="text-xl font-semibold mb-2">Success!</h2>
                <p><?php echo $success_message; ?></p>
            </div>
        <?php endif; ?>

        <!-- Error Message -->
        <?php if ($error_message): ?>
            <div class="text-red-500">
                <h2 class="text-xl font-semibold mb-2">Error!</h2>
                <p><?php echo $error_message; ?></p>
            </div>
        <?php endif; ?>

        <!-- Close Button -->
        <button onclick="closeModal()" class="mt-4 bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600">Close</button>
    </div>
</div>

<script>
    // Function to close the modal
    function closeModal() {
        document.getElementById('modal').style.display = 'none';
    }
</script>

</body>
</html>

<?php
$conn->close();
?>
