<?php
include 'navbar.php'; // Include the Navbar
include 'db.php';

// Handle restore action (order moves to pending)
if (isset($_GET['restore']) && isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'];
    $restore_sql = "UPDATE orders SET status = 'pending' WHERE id = $order_id"; // Move to pending
    if ($conn->query($restore_sql) === TRUE) {
        // After restoring, refresh the page to show the changes in dashboard
        echo "<script>window.location.href = 'dashboard.php';</script>";
    } else {
        echo "Error restoring order: " . $conn->error;
    }
}

// Handle delete action (permanently delete the order)
if (isset($_GET['delete']) && isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'];
    // Permanently delete the order from the database
    $delete_sql = "DELETE FROM orders WHERE id = $order_id"; 
    if ($conn->query($delete_sql) === TRUE) {
        // Redirect to refresh the Trash page after deletion
        echo "<script>window.location.href = 'trash.php';</script>";
    } else {
        echo "Error deleting order: " . $conn->error;
    }
}

// Fetch orders in trash
$sql = "SELECT * FROM orders WHERE status = 'trash' ORDER BY order_date DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trash Orders</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="container mx-auto py-8 px-4 sm:px-6 lg:px-8">
    <h1 class="text-4xl font-semibold text-center text-gray-800 mb-8">Trash Orders</h1>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $orderDate = date("Y-m-d g:i A", strtotime($row['order_date']));

                echo "<div class='bg-white p-6 rounded-lg shadow-lg hover:shadow-2xl transition-shadow'>
                        <h3 class='text-xl font-semibold text-gray-800'>Order ID: " . $row['id'] . "</h3>
                        <p class='text-gray-600 mt-2'><strong>Shop Name:</strong> " . $row['shop_name'] . "</p>
                        <p class='text-gray-600 mt-2'><strong>Full Address:</strong></p>
                        <textarea id='address-" . $row['id'] . "' class='w-full h-20 p-2 mt-2 bg-gray-100 border border-gray-300 rounded-lg' readonly>" . $row['full_address'] . "</textarea>
                        <button class='bg-green-500 text-white p-2 rounded-lg mt-2 w-full hover:bg-green-600' onclick='copyToClipboard(" . $row['id'] . ")'>Copy Address</button>
                        <p class='text-gray-600 mt-2'><strong>Order Date:</strong> " . $orderDate . "</p>
                        <div class='flex gap-2 mt-4'>
                            <a href='trash.php?restore=1&order_id=" . $row['id'] . "' class='bg-yellow-500 text-white py-2 px-4 rounded-lg flex-1 text-center hover:bg-yellow-600'>Restore</a>
                            <a href='trash.php?delete=1&order_id=" . $row['id'] . "' class='bg-red-500 text-white py-2 px-4 rounded-lg flex-1 text-center hover:bg-red-600'>Delete</a>
                        </div>
                    </div>";
            }
        } else {
            echo "<p class='text-center text-gray-600'>No orders in trash</p>";
        }
        ?>
    </div>
</div>

<script>
    // Function to copy address to clipboard
    function copyToClipboard(orderId) {
        var textarea = document.getElementById('address-' + orderId);
        textarea.select();
        textarea.setSelectionRange(0, 99999); // For mobile devices
        document.execCommand('copy');
        alert("Address copied to clipboard!");
    }
</script>

</body>
</html>

<?php
$conn->close();
?>
