<?php
include 'navbar.php'; // Include the Navbar

include 'db.php';

// Pagination setup
$ordersPerPage = 20; // Number of orders per page
$page = isset($_GET['page']) ? $_GET['page'] : 1; // Current page
$offset = ($page - 1) * $ordersPerPage; // Calculate the offset for the SQL query

// Get the total number of orders to calculate total pages
$totalOrdersSql = "SELECT COUNT(*) FROM orders WHERE status != 'trash' AND status != 'confirmed'"; // Exclude 'done' orders
$totalOrdersResult = $conn->query($totalOrdersSql);
$totalOrders = $totalOrdersResult->fetch_row()[0];
$totalPages = ceil($totalOrders / $ordersPerPage); // Calculate total pages

// Fetch orders with pagination, excluding 'confirmed' and 'trash' orders
$sql = "SELECT * FROM orders WHERE status != 'trash' AND status != 'confirmed' ORDER BY order_date DESC LIMIT $ordersPerPage OFFSET $offset";
$result = $conn->query($sql);

// Check for Confirm action (confirm the order)
if (isset($_GET['confirm']) && isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'];
    $confirm_sql = "UPDATE orders SET status = 'confirmed' WHERE id = $order_id";
    if ($conn->query($confirm_sql) === TRUE) {
        echo "Order confirmed successfully!";
        header('Location: dashboard.php'); // Redirect to avoid re-submit on page refresh
    } else {
        echo "Error confirming order: " . $conn->error;
    }
}

// Check for Hold action (put the order on hold)
if (isset($_GET['hold']) && isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'];
    $hold_sql = "UPDATE orders SET status = 'hold' WHERE id = $order_id";
    if ($conn->query($hold_sql) === TRUE) {
        echo "Order put on hold!";
        header('Location: dashboard.php');
    } else {
        echo "Error holding order: " . $conn->error;
    }
}

// Check for Trash action (move the order to trash)
if (isset($_GET['trash']) && isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'];
    $trash_sql = "UPDATE orders SET status = 'trash' WHERE id = $order_id";
    if ($conn->query($trash_sql) === TRUE) {
        echo "Order moved to trash.";
        header('Location: dashboard.php'); // Redirect to avoid re-submit on page refresh
    } else {
        echo "Error moving order to trash: " . $conn->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Dashboard</title>
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="container mx-auto py-10 px-4 sm:px-6 lg:px-8">
    <h1 class="text-4xl font-semibold text-center text-gray-800 mb-8">Order Dashboard</h1>

    <h2 class="text-2xl font-semibold text-gray-800 mb-6">All Orders</h2>

    <!-- Orders Container -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                // Format the Order Date to include both date and 12-hour time format
                $orderDate = date("Y-m-d g:i A", strtotime($row['order_date'])); // e.g., 2025-07-03 12:30 PM

                echo "<div class='bg-white p-6 rounded-lg shadow-lg hover:shadow-2xl transition-shadow'>
                        <h3 class='text-xl font-semibold text-gray-800'>Order ID: " . $row['id'] . "</h3>
                        <p class='text-gray-600 mt-2'><strong>Shop Name:</strong> " . $row['shop_name'] . "</p>
                        <p class='text-gray-600 mt-2'><strong>Full Address:</strong></p>
                        <textarea id='address-" . $row['id'] . "' class='w-full h-20 p-2 mt-2 bg-gray-100 border border-gray-300 rounded-lg' readonly>" . $row['full_address'] . "</textarea>
                        <button class='bg-green-500 text-white p-2 rounded-lg mt-2 w-full hover:bg-green-600' onclick='copyToClipboard(" . $row['id'] . ")'>Copy Address</button>
                        <p class='text-gray-600 mt-2'><strong>Order Date:</strong> " . $orderDate . "</p>
                        <p class='text-gray-600 mt-2'><strong>Status:</strong> <span class='font-bold'>" . ucfirst($row['status']) . "</span></p>

                        <div class='flex gap-2 mt-4'>
                            <a href='dashboard.php?confirm=1&order_id=" . $row['id'] . "' class='bg-blue-500 text-white py-2 px-4 rounded-lg flex-1 text-center hover:bg-blue-600'>Confirm</a>
                            <a href='dashboard.php?hold=1&order_id=" . $row['id'] . "' class='bg-yellow-500 text-white py-2 px-4 rounded-lg flex-1 text-center hover:bg-yellow-600'>Hold</a>
                        </div>
                        <a href='dashboard.php?trash=1&order_id=" . $row['id'] . "' class='bg-red-500 text-white py-2 px-4 rounded-lg w-full mt-4 text-center hover:bg-red-600 block'>Trash</a>
                    </div>";
            }
        } else {
            echo "<p class='text-center text-gray-600'>No orders found</p>";
        }
        ?>
    </div>

    <!-- Pagination Links -->
    <div class="flex justify-center mt-6">
        <?php if($page > 1): ?>
            <a href="dashboard.php?page=<?php echo $page - 1; ?>" class="bg-blue-500 text-white py-2 px-6 rounded-lg hover:bg-blue-600">Previous</a>
        <?php endif; ?>

        <?php if($page < $totalPages): ?>
            <a href="dashboard.php?page=<?php echo $page + 1; ?>" class="bg-blue-500 text-white py-2 px-6 rounded-lg hover:bg-blue-600 ml-4">Next</a>
        <?php endif; ?>
    </div>
</div>

<script>
    // Function to copy address to clipboard
    function copyToClipboard(orderId) {
        var textarea = document.getElementById('address-' + orderId); // Get the textarea by order ID
        textarea.select(); // Select the text in the textarea
        textarea.setSelectionRange(0, 99999); // For mobile devices
        document.execCommand('copy'); // Copy the text inside the textarea
    }

    // Function to automatically resize the textarea based on its content
    document.querySelectorAll('textarea').forEach(textarea => {
        textarea.addEventListener('input', function () {
            this.style.height = 'auto'; // Reset the height to 'auto'
            this.style.height = (this.scrollHeight) + 'px'; // Set height to match the content
        });
        // Initial resize for any pre-filled textareas
        textarea.style.height = (textarea.scrollHeight) + 'px';
    });
</script>

</body>
</html>

<?php
$conn->close();
?>
